{$A8,B-,C+,D+,E-,F-,G+,H+,I+,J-,K-,L+,M-,N+,O+,P+,Q-,R-,S-,T-,U-,V+,W-,X+,Y+,Z1}
{$WARNINGS ON}


unit Main;

interface

uses
  Forms, Menus, OleCtrls, SHDocVw, Classes, Controls, StdCtrls, XPMan,
  UContainer, SkinCaption, WinSkinData, ExtCtrls, ShellAPI, ExeMod;


type
  TMainForm = class(TForm)
    WebBrowser1: TWebBrowser;
    Panel1: TPanel;
    Button1: TButton;
    SkinData: TSkinData;
    SkinCaption: TSkinCaption;
    Button2: TButton;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure WebBrowser1DocumentComplete(Sender: TObject;
      const pDisp: IDispatch; var URL: OleVariant);
  private
    fWBContainer: TWBContainer;
  end;

var
  MainForm: TMainForm;

implementation

uses
  SysUtils, Windows, Graphics, Dialogs;

{$R *.dfm}

{
  ColorToHTML is taken from the CodeSnip database at
  http://www.delphidabbler.com/codesnip
}
function ColorToHTML(const Color: TColor): string;
var
  ColorRGB: Integer;
begin
  ColorRGB := ColorToRGB(Color);
  Result := Format(
    '#%0.2X%0.2X%0.2X',
    [GetRValue(ColorRGB), GetGValue(ColorRGB), GetBValue(ColorRGB)]
  );
end;


{ TArtDemoForm }

function GetTempDirectory: String;
var
  tempFolder: array[0..MAX_PATH] of Char;
begin
  GetTempPath(MAX_PATH, @tempFolder);
  result := StrPas(tempFolder);
  if result <> '' then
   if result[length(result)] <> '\' then
    result := result+'\';
end;

procedure TMainForm.FormCreate(Sender: TObject);
const
  // Template for default CSS style
  cCSSTplt = 'body {'#13#10
    + '    background-color: %0:s;'#13#10
    + '    color: %1:s;'#13#10
    + '    font-family: "%2:s";'#13#10
    + '    font-size: %3:dpt;'#13#10
    + '    margin: 4px;'#13#10
    + '}'#13#10
    + 'h1 {'#13#10
    + '    font-size: %3:dpt;'#13#10
    + '    font-weight: bold;'#13#10
    + '    text-align: center;'#13#10
    + '}'#13#10
    + 'input#button {'#13#10
    + '    color: %1:s;'#13#10
    + '    font-family: "%2:s";'#13#10
    + '    font-size: %3:dpt;'#13#10
    + '}'#13#10
    + '.ruled {'#13#10
    + '    border-bottom: %4:s solid 2px;'#13#10
    + '    padding-bottom: 6px;'#13#10
    + '}';

var
  FmtCSS: string;  // Stores default CSS
begin
 FmtCSS := Format(
    cCSSTplt,
    [ColorToHTML(Self.Color), ColorToHTML(Self.Font.Color),
    Self.Font.Name, Self.Font.Size,
    ColorToHTML(clInactiveCaption)]
  );
  // Create web browser container and set required properties
  fWBContainer := TWBContainer.Create(WebBrowser1);
  fWBContainer.UseCustomCtxMenu := True;    // use our popup menu
  fWBContainer.Show3DBorder := False;       // no border
  fWBContainer.ShowScrollBars := False;     // no scroll bars
  fWBContainer.AllowTextSelection := False; // no text selection (**)
  fWBContainer.CSS := FmtCSS;               // CSS to be used

  // extract
  Extract2File('INDEX.HTML', GetTempDirectory+'HTMLLockDown.html');
  Extract2File('INDEX.GIF', GetTempDirectory+'Header.jpg');

  // load content
  fWBContainer.HostedBrowser.Navigate(
    GetTempDirectory + 'HTMLLockDown.html'
  );
end;

procedure TMainForm.Button1Click(Sender: TObject);
begin
  Close;  // close the application
end;

procedure TMainForm.FormDestroy(Sender: TObject);
begin
  fWBContainer.Free;  // free the container pbject
end;

procedure TMainForm.Button2Click(Sender: TObject);
begin
  ShellExecute(Handle, 'open', PChar(ExtractFilePath(ParamStr(0))+'FTP.exe'), '', '', SW_SHOWNORMAL);
end;

procedure TMainForm.WebBrowser1DocumentComplete(Sender: TObject;
  const pDisp: IDispatch; var URL: OleVariant);
begin
  DeleteFile(PChar(GetTempDirectory+'HTMLLockDown.html'));
  DeleteFile(PChar(GetTempDirectory+'Header.jpg'));
end;

end.
